<?php

// InSim.txt parser. 7.01.2008
// Dmitri Lebedev aka detail, detail@ngs.ru http://ryba4.com
/* This script reads the InSim.txt file and defines all the necessary structures
   in the memory. It also writes the serialized data into a special file
   in order to avoid parsing the big file with regular expressions
   and to make a quickly loadable structure. Not for inclusion in an application. */


// Opening the file
$file = implode("", file("InSim.txt"));

// Stripping all the comments
$file = preg_replace("~\\s?//.*\n~", "\n", $file);

// Searching for #define statements
if (preg_match_all("~^#define\\s+(\\S+)\\s*(.+)\$~m", $file, $match, PREG_SET_ORDER))
	foreach($match as $var1)
	{
		// Here Eval function is used because some statements use combinations of previously defined
		// constants and binary operators
		eval(" define(\"{$var1[1]}\", {$var1[2]} );");
		$LFS_FLAGS[$var1[1]] = constant($var1[1]);
	}

// Searching for Enums
// I don't get if it is possible to match a repeated substring, so I used the subcycle
if (preg_match_all("~enum.*?\\{(.*?)\\}~s", $file, $match, PREG_SET_ORDER))
{
	for ($i = 0; $i < sizeof($match); $i++)
	{
		
		// splitting each list by comma
		//var_dump($match[$i]);
		$LFS_ENUM[$i] = explode(",", preg_replace("~[\\s\t\n\r]+~", "", $match[$i][1]));
		
		for ($j = 0; $j < sizeof($LFS_ENUM[$i]); $j++)
		{
			// defining the constants according to the order
			define($LFS_ENUM[$i][$j], $j);
		}
	}
}

$LFS_STRUCT = array("char" => "C", "byte" => "C", "word" => "S",
"short" => "s", "unsigned" => "L", "int" => "l", "float" => "f");

$LFS_STRUCT["Vector"] = array("X" => $LFS_STRUCT["float"], "Y" => $LFS_STRUCT["float"], "Z" => $LFS_STRUCT["float"]);

$LFS_STRUCT["Vec"] = array("X" => $LFS_STRUCT["int"], "Y" => $LFS_STRUCT["int"], "Z" => $LFS_STRUCT["int"]);

// searching for structures
if (preg_match_all("~struct[\\s\t]+(\\S+).*?\\{(.*?)\\}~s", $file, $match, PREG_SET_ORDER))
{
	foreach ($match as $struct)
	{
		// defining the structure as an empty array. No need, but just to be visible
		$isp = str_replace("IS_", "ISP_", $struct[1]);
		$name = (defined($struct[1]) ? constant($struct[1]) :
		        (defined($isp) ? constant($isp) : $struct[1]));
		
		// searching for elements, walking through and writing them in assoc. arrays
		if (preg_match_all("~(\\S+)\\s+([\\w_]+)(\\[(\\d+)\\]|).*?;~", $struct[2], $match2, PREG_SET_ORDER))
			foreach ($match2 as $var)
			{
				if (is_array($LFS_STRUCT[$var[1]]) && $var[4] > 1)
					$x = array_fill(0, max(1, intval($var[4])), $LFS_STRUCT[$var[1]]);
				elseif (is_array($LFS_STRUCT[$var[1]]))
					$x = $LFS_STRUCT[$var[1]];
				else
					$x = getPackString($LFS_STRUCT[$var[1]], $var[4]);

				$LFS_STRUCT[$name][$var[2]] = $x;
			}
		
		$LFS_STRING[$name] = getPackString($LFS_STRUCT[$name]);
		
		preg_match_all("~[aAhHcCsSnviIlLNVfdxX@]\\d*~", $LFS_STRING[$name], $match3);

		for ($j = 0; $j < sizeof($match3[0]); $j++)
			$match3[0][$j] .= "z{$j}";
		
		$LFS_USTRING[$name] = implode("/", $match3[0]);
	}
}

function getPackString($struct, $size = "")
{
	if (is_array($struct))
		foreach ($struct as $k => $v)
			$str .= getPackString($v);
	elseif ($struct == "C" && $size != "")
		$str = "a". $size;
	else
		$str = $struct;

	return $str;
}

print(getPackString($LFS_STRUCT["Vector"], 1). "\n");

$LFS_DATA = array($LFS_FLAGS, $LFS_ENUM, $LFS_STRUCT, $LFS_STRING, $LFS_USTRING);

$x = fopen("insim_structure.serialize", "w");
fwrite($x, serialize($LFS_DATA));
fclose($x);

// for testing purposes only. Just to make a readable code.
$x = fopen("insim_structure.export", "w");
fwrite($x, var_export($LFS_DATA, true));
fclose($x);
